package control;

import java.util.Iterator;
import abstraction.*;

/**
 * @author Balestra Concetta, Coccia Chiara, Colarullo Diego
 * @version 2.0 09/05/29
 * @since JDK 1.6
 */


/**
 * This Class is an iterator on community final states and allows to build Cartesian product on fly
 */
public class IteratorFinalCommunityStates implements Iterator<CState> {

	private State[] presentConfiguration;
	private Iterator<State>[] next;
	private AvailableServices services;
	private boolean hasNext;
	
	@SuppressWarnings("unchecked")
	public IteratorFinalCommunityStates (AvailableServices services){
		this.hasNext = true;
		this.services = services;
		int dim = services.sizeCommunity();
		presentConfiguration = new State[dim];
		next = new Iterator[dim];
		for (int i = 0; i < dim; i++) {
			Iterator<State> it = services.get(i).getFinalStates();
			State s = it.next();
			presentConfiguration[i]=s;
			next[i] = it;
		}
	}
	
	/**
	 * gets the present configuration an creat the next one
	 * @return CState
	 */
	public CState next(){
		CState result = new CState(presentConfiguration);
		for (int i = 0; i <services.sizeCommunity(); i++) {
			Iterator<State> it = next[i];
			if(it.hasNext()) {
				State s = (State)it.next();
				presentConfiguration[i]=s;
				next[i] = it;
				
				return result;
			}
			else {
				Iterator<State> it2 = services.get(i).getFinalStates();
				State s1 = (State)it2.next();
				presentConfiguration[i] = s1;
				next[i] = it2;
			}
		}
		this.hasNext = false;
		return result;
	}
	
	/**
	 * says if the iterations of Cartesian product are terminated
	 * @return boolean
	 */
	public boolean hasNext() {
		return this.hasNext;
	}
	
	/**
	 * remove operation isn't allows for thhis structures. 
	 * Every remove's call preduce the throw of an exception  
	 */
	public void remove() {
		throw new UnsupportedOperationException();
	}
}
